/* sources:
1. 计量经济圈
2. lianxh
3. 陈强
*/

clear all
set more on
set mat 800
capture log close

use "F:\Project1_empirical\coredunew.dta"
order year, after(prefect)

gen ocp=4/11 if year==2002
replace ocp=9/11 if year==2007
replace ocp=1 if year==2013

gen ocp1=1 if year==2013
replace ocp1=0 if year!=2013

gen lnshare2030=ln(share2030)
gen lnpopdensity=ln(popdensity)
gen lngdppc=ln(gdppc)
gen lnawage=ln(avewage)
gen lnfdi=ln(fdi)
gen lndeposits=ln(deposits)
gen lntotpop=ln(totpop)
gen lnfixassetinv=ln(fixassetinv)
gen lncolleges=ln(colleges)
gen lnhighschools=ln(highschools)
gen lnnonarpop=ln(nonarpop)
gen lnpoppref=ln(poppref)

gen lnsrpref=ln(srpref) // lnX

gen lntone=ln(toneemployshare)
gen lnttwo=ln(t2employshare) 
gen lnt3=ln(t3employshare)

tab pv, gen(pd) // 16 pv dummy //
tab year, gen(yd) //year dummy //

gen lnabonus=ln(abonus1)

*gen inter=finenorm*(pd*)

sum cor_prefect srpref /* mean(cor_cor_prefect) = .6537393 StD = .4934031 */
* mean(srpref) = 1.031167, StD = .0750475 *

* kdensity cor_prefect // 连续直方图 skewness=-2.2173 kurtosis=7.4493 //
* kdensity srpref // looks like a normal distribution //

global zlist share2030 lnpopdensity lngdppc lnavewage lnfdi lndeposits ///
lntotpop lnfixassetinv toneindusgdp t2indusgdp t3indusgdp

global zlist2 share2030 lnpopdensity lngdppc lnfdi lndeposits ///
lncolleges lnhighschools //include local demographic, economic, education information//

/* dropped var list
orgin var list:
share2030 lnpopdensity lngdppc lnavewage lnfdi lndeposits ///
lncolleges lnhighschools

1. - lnhighschools lngdppc // not good
2. - lnhighschools lngdppc lnfdi // not good
3. - lnhighschools lnfdi  + share1564 // not good
4. - lnfdi lndeposits // not good
5. - lnfdi // not good 
6. + lntotpop lnfixassetinv // not good 
7. - lnavewage and add as IV


Potential IV:
1. 人口自然增长率 过去5年, 1/5\sum{(ln(Pop_{t})-ln(Pop_{t-1}))-PopNG_{t}}
2. 城镇登记失业人数
3. 三大产业从业人员比重
4. 三大产业占GDP的比重
5. 年平均从业人数
6. 劳动工资，在岗职工平均人数，职工平均工资，在岗职工工资总额
7. 客运总量


*/

global zlist3 share2030 lnpoppref lngdppc lndeposits lnhighschools

*———————————————————————————————————————————————————————————————————————————————
************************************* IV ***************************************
********************************************************************************

sum srpref afine1 afine2 ocp

pwcorr srpref afine1 ocp, sig // weak IV? //

** (1)

* F > 10, 

ivregress 2sls cor_prefect /// 
(srpref = afine1  pd* lnawage) $zlist2 yd*, r cluster(prefect) first

ivregress liml cor_prefect /// 
(srpref = afine1 apremium1 pd* lnawage) $zlist2 yd*, r cluster(prefect) first // not good //

estat overid // overidentification test //
*fail to reject null hypothesis, H0= all IVs are exogenous

estat firststage, all forcenonrobust // weak IV test //
*Robust F(17,72)= 11.3169 Prob>F 0.00
*No weak IV problem*


ivregress 2sls cor_prefect /// 
(srpref = fine i.pv lnawage) $zlist2 , r cluster(prefect) first

estat overid // overidentification test //
*fail to reject null hypothesis, H0= all IVs are exogenous

estat firststage, all forcenonrobust // weak IV test //
*Robust F(17,72)= 11.3169 Prob>F 0.00
*No weak IV problem*

reg srpref fine pd1-pd16 $zlist2 i.year, r

ivreg2 cor_prefect /// 
(srpref = afine1 apremium1 pd1-pd16 lnawage) $zlist2 yd*, ffirst r cluster(prefect)



* hausman test for endogenity of srpref *
qui reg cor_prefect srpref ///
$zlist2 i.year
eststo ols
qui ivregress 2sls cor_prefect /// 
$zlist2 i.year (srpref = fine i.pv lnavewage)
eststo iv
hausman iv ols, constant sigmamore

* Assign an extra unit of sr to a randomly chosen prefectures in the population


qui reg cor_prefect srpref $zlist2 i.year, r cluster(prefect)
eststo OLS_no_fine

qui reg cor_prefect finenorm srpref $zlist2 i.year, r cluster(prefect)
eststo OLS_wtih_fine

qui ivregress 2sls cor_prefect $zlist2 i.year (srpref = finenorm i.pv lnavewage), r cluster(prefect)
eststo twosls

qui ivregress liml cor_prefect $zlist2 i.year (srpref = finenorm i.pv lnavewage), r cluster(prefect)
eststo liml

qui ivregress gmm cor_prefect $zlist2 i.year (srpref = finenorm i.pv lnavewage)
eststo gmm

qui ivregress gmm cor_prefect $zlist2 i.year (srpref = finenorm i.pv lnavewage), igmm
eststo igmm

esttab OLS_no_fine OLS_wtih_fine twosls liml gmm igmm, se r2 mtitle ///
star(* .10 ** .05 *** .01)




eststo clear

                              ** First stage **
/* fine rate (fine1) correlate with province-specific fix effect 
and time fix effect.
	
*/	

eststo iv1: qui reg srpref afine1  /// 
$zlist2 pd* yd*, r cluster(prefect)

eststo iv2: qui reg srpref afine1 apremium1  /// 
$zlist2 pd* yd*, r cluster(prefect)

eststo iv3: qui reg srpref afine1 lnawage ///
$zlist2 pd* yd*, r cluster(prefect)

eststo iv4: qui reg srpref afine1 apremium1 lnawage ///
$zlist2 pd* yd*, r cluster(prefect)

estout iv*, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05) ///
        stats(r2 aic N, fmt(%8.2f %8.0g) ) replace 

                              ** Second stage **
eststo ab1: ivreg2 cor_prefect (srpref= afine1 pd*) /// 
$zlist2 yd*, ffirst r cluster(prefect)

eststo ab2: ivreg2 cor_prefect (srpref= afine1 apremium1 pd*) /// 
$zlist2 yd*, ffirst r cluster(prefect)

eststo ab3: ivreg2 cor_prefect (srpref= afine1 lnawage pd*) /// 
$zlist2 yd*, ffirst r cluster(prefect)

eststo ab4: ivreg2 cor_prefect (srpref= afine1 apremium1 lnawage pd*) /// 
$zlist2 yd*, ffirst r cluster(prefect)

estout ab*, cells(b(star fmt(%9.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 ) ///
stats(r2 aic whf jp widstat N, fmt(%9.2f %9.0f %9.2f %9.2f %9.2f %9.0g)) replace 

		**** outpout WHF test 
eststo b1iv: xi: ivreg2 cor_prefect (srpref= afine1 pd*) /// 
$zlist2 yd*, ffirst
ivendog srpref
estadd scalar whf= r(WHFp)

eststo b1iv: xi: ivreg2 cor_prefect (srpref= afine1 apremium1 pd*) /// 
$zlist2 yd*, ffirst
ivendog srpref
estadd scalar whf= r(WHFp)	

eststo b1iv: xi: ivreg2 cor_prefect (srpref= afine1 lnawage pd*) /// 
$zlist2 yd*, ffirst
ivendog srpref
estadd scalar whf= r(WHFp)	

eststo b1iv: xi: ivreg2 cor_prefect (srpref= afine1 apremium1 lnawage pd*) /// 
$zlist2 yd*, ffirst
ivendog srpref
estadd scalar whf= r(WHFp)
estout b*iv,         stats(whf widstat, fmt(%9.2f %9.2f))  replace 


